

/******************************************************************************************************
 *                                                                                                    *
 *                        Example_1. ET-REMOTE MP3 Trig-Mode By Command                               *
 *                                                                                                    *
 ******************************************************************************************************
 *                                                                                                    *
 * Target MCU     : ATMEL AVR-MEGA128 (ET-BASE AVR atmega128 r3)                                      *
 *                : X-TAL : 16 MHz                                                                    *  
 *                                                                                                    *
 * Editor         : AVR Studio 4.15 Build 623                                                         *
 * Compiler       : WinAVR-20081205                                                                   *
 *                                                                                                    *
 * Port Interface :                                                                                   *
 *                                                                                                    *
 *            I/O : # MCU-MEGA128 #           # ET-MINI 3TO5TTL #                  # ET-REMOTE MP3 #  *
 *                  --------------          -------------------------              -----------------  *
 *                                                                                                    *                                   
 *                  PA0..PA7(OUT)  connect  IN0-IN7(#1)<--> OUT0-OUT7(#1)  connect     Trig CH1-CH8   *                                        
 *                  PC0..PC7(OUT)  connect  IN0-IN7(#2)<--> OUT0-OUT7(#2)  connect     Trig CH9-CH16  *                            
 *                  +5V            connect  +VIN (#1,#2)<--> +VOUT(#1,#2)  connect     +3.3V          *
 *                  GND1           connect  GND1 (#1,#2)<--> GND2 (#1,#2)  connect     GND2           *                                                                 *
 *                                                                                                    *
 *          UART0 : PE0 = RX0                                                                         *
 *                  PE1 = TX0                                                                         *
 *                  BAUD RATE 9600                                                                    *
 *                                                                                                    *
 *                                                                                 -DIP SW.MODE       * 
 *  CMM     5V                                                                       S1=OFF,S2=OFF    *
 *  Rx0    --+--                                            +------------------+   -DIP SW.CONFIG     *
 *  ^        |                                              |                  |     S1=OFF,S2=ON     *
 *  |        +----------+                                   |          --------+-----------           *
 *  |        |          |      -----------------------      |         |     +VOUT3V3       |          *
 *  |  ------+-----     +-----|+VIN              +VOUT|-----+    Trig |                    |          *
 *  | |        PA0 |----|-----|IN0                OUT0|-----|---------|CH1                 |          *
 *  +-|PE0      .  |    |     | .                  .  |     |         | .                  |          *
 *    |         .  |    |     | .   ET-MINI3TO5#1  .  |     |         | .                  |          *
 *    |         .  |    |     | .                  .  |     |         | .                  |          *
 * Tx0|        PA7 |----|-----|IN7                OUT7|-----|---------|CH8                 |          *
 *    |            |    |  +--|G1                  G2 |--+  |         |                    |          *
 *  ^ |            |    |  |  +-----------------------+  |  |         |   ET-REMOTE MP3V2  |          *
 *  | |            |    +--|--|+VIN              +VOUT|--|--+    Trig |                    |          *
 *  | |        PC0 |-------|--|IN0                OUT0|--|------------|CH9                 |          *
 *  | |         .  |       |  | .                  .  |  |            | .                  |          *
 *  | |         .  |       |  | .   ET-MINI3TO5#2  .  |  |            | .                  |          *
 *  +-|PE1      .  |       |  | .                  .  |  |            | .                  |          *
 *      |      PC7 |-------|--|IN7                OUT7|--|------------|CH16   [Supply]     |          *
 *     -----+------        +--|G1                   G2|--+            |       G2   5V      |          *
 *          |  Mega 128    |   -----------------------   |             -------+-----+------           *
 *        --+--          --+--                           |                    |     |                 *
 *         ---            ---                            +--------------------+     |                 *
 *          -              -                                                  |     +-->5V            *
 *                                                                          --+--                     *
 *                                                                          \   /                     *
 *                                                                           \ /                      *
 *                                                                                                    *
 *                                                                                                    *
 *   ASCII Command For Test :  +----------+-------------+---------------+                             *
 *                             |Start Byte| Number Song |      End      |                             *
 *                             +----------+-------------+---------------+                             *
 *                             |  1Byte   |   2Byte     |    1 Byte     |                             *
 *                             +----------+-------------+---------------+                             *
 *                             |    *     |    01-16    |  0x0D (Enter) |                             *
 *                             +----------+-------------+---------------+                             *
 *                                                                                                    *
 *                                                                                                    *
 * Last Update     : 22/May/2012                                                                      *   
 * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                             *
 *                                                                                                    * 
 ******************************************************************************************************/




#include <stdio.h>
#include <avr/io.h>                  //define port
#include <compat/deprecated.h>       //call function sbi(port,bit),cbi(port,bit) = Set,Clear bit
#include <avr/interrupt.h>



#define F_CPU 16000000UL             //CPU Clock Frequency (Hz)
#include <util/delay.h>              //call function delay


unsigned char enter,cmm_cnt=0,cmm_buf[3] ;


/*****************************************
 **         Function Delay ms           **
 *****************************************/

 void delay_ms(unsigned int cnt)
  {
    for(;cnt>0;cnt--)
       _delay_ms(1);
  }



/***************************************************************
 **                 Function use For Printf(UART0)            **
 ***************************************************************/


//--------------------- Prototype function ---------------------

static int uart_putchar(char c,FILE *stream) ;
static FILE uart_str = FDEV_SETUP_STREAM(uart_putchar,NULL,_FDEV_SETUP_WRITE);
void Init_Serial(unsigned int baudrate);


//----------------------- UART0 Putchar -------------------------

static int uart_putchar(char c,FILE *stream)
 {
   if(c=='\a')
     {
     fputs("*ring*\n",stderr) ;
     return 0 ;
     }
   
   if(c=='\n')
     uart_putchar('\r',stream) ;

   loop_until_bit_is_set(UCSR0A,UDRE);
   UDR0 = c ;

   return 0 ;
 }


//------------------- Initial UART0 -----------------------

static void UART0_Init(void)
 {

   UCSR0B = 0x00      ;     //disable while setting baud rate
   UBRR0H = 0         ;
   UBRR0L = 103       ;     //Set Baud Rate 9600
  
   UCSR0C = 0x06      ;     //Set Frame format : 8data,NoneParity,1stop bit
   UCSR0B = 0x98      ;     //Uart0 Control Enable Reciver and transmitter and INT.Rx
   
   sei ();                  //Enable Gobal Interrup

   stdout = &uart_str ;     //Set address uart_str to stdout

   

 }





/*****************************************
 **        Function Initial Port        **
 *****************************************/

 void Init_Port(void)
  {

   DDRA  = 0xFF     ;        //Set PA(0..7) = Output for Trig CH1-8  
     
   DDRC  = 0xFF     ;        //Set PC(0..7) = Output for Trig CH9-16  
    

 //--- Set default output Port = 1  ----

                 
   PORTC = 0xFF     ;
   PORTA = 0xFF     ;  
   

  }



 /****************************************************
  **                                                **
  **     Function Interrup Service-Uart0 RX         **
  **                                                **
  ****************************************************/ 

 ISR(USART0_RX_vect)
  {
     unsigned char rxd      ;
    
       rxd   = UDR0        ;  //Read data 
   
   
      if(rxd != 0x0D)           
        {
         //---------------- Keep Command 3 byte : *,cmm,cmm -------------------   
   
         if(cmm_cnt < 3)
           {   
             cmm_buf[cmm_cnt] = rxd ;  // keep data
             cmm_cnt++              ;
           }
        }
   
      //------ Clear Valiable for Recive New Command -------------

        if(rxd == 0x0D)               
        {
          enter = 0x0D               ;  
            cmm_cnt = 0              ;  //Clear Counter Command   
        }

   }





 /****************************************************
  **                                                **
  **              Function Read Command             **
  **                                                **
  ****************************************************/ 


void chk_cmm(void)
{
     unsigned char cm1,cm2 ; 

     if(enter == 0x0D)                          // Check Enter
     {  
       enter  = 0x00  ;                        // Clear valiable 'enter'
         
         if(cmm_buf[0]== '*')                   // Check Start Byte
          {       
            cm1 = (cmm_buf[1]-0x30)*10    ;   //Convert CMM Ascii to  decimal colum 10
            cm2 = (cmm_buf[2]-0x30)+cm1   ;   //Convert CMM Ascii to  decimal colum 1
                         
                           
              //------------------ Sent Signal Trig Follow Command -----------------------

           switch(cm2)
             {
              case 1 :     //--------------- TRIG-CH1(PA0)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                    cbi(PORTA,0)           ;    //PA0=0 : Trig-CH1   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                    sbi(PORTA,0)           ;    //PA0=1  

                    printf("#OK\n\r")      ;    //Sent Echo Command 
              break ;


             case 2 :     //--------------- TRIG-CH2(PA1)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                    cbi(PORTA,1)           ;    //PA1=0 : Trig-CH2   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                    sbi(PORTA,1)           ;    //PA1=1  

                    printf("#OK\n\r")      ;    //Sent Echo Command 
              break ;

                 case 3 :     //--------------- TRIG-CH3(PA2)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                    cbi(PORTA,2)           ;    //PA2=0 : Trig-CH3   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                    sbi(PORTA,2)           ;    //PA2=1  

                    printf("#OK\n\r")      ;    //Sent Echo Command 
              break ;


                 case 4 :     //--------------- TRIG-CH4(PA3)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                    cbi(PORTA,3)           ;    //PA3=0 : Trig-CH4   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                    sbi(PORTA,3)           ;    //PA3=1  
 
                    printf("#OK\n\r")      ;    //Sent Echo Command 
              break ;


            
                 case 5 :     //--------------- TRIG-CH5(PA4)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                    cbi(PORTA,4)           ;    //PA4=0 : Trig-CH5   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                    sbi(PORTA,4)           ;    //PA4=1  

                    printf("#OK\n\r")      ;    //Sent Echo Command 
              break ;


            
                 case 6 :     //--------------- TRIG-CH6(PA5)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                    cbi(PORTA,5)           ;    //PA5=0 : Trig-CH6   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                    sbi(PORTA,5)           ;    //PA5=1  

                    printf("#OK\n\r")      ;    //Sent Echo Command 
              break ;


            
                 case 7 :     //--------------- TRIG-CH7(PA6)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                    cbi(PORTA,6)           ;    //PA6=0 : Trig-CH7   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0
 
                    sbi(PORTA,6)           ;    //PA6=1  

                    printf("#OK\n\r")      ;    //Sent Echo Command 
              break ;

            
                 case 8 :     //--------------- TRIG-CH8(PA7)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                    cbi(PORTA,7)           ;    //PA7=0 : Trig-CH8   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                    sbi(PORTA,7)           ;    //PA7=1  
 
                    printf("#OK\n\r")      ;    //Sent Echo Command 
              break ;


            
                 case 9 :     //--------------- TRIG-CH9(PC0)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                    cbi(PORTC,0)          ;    //PC0=0 : Trig-CH9   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                    sbi(PORTC,0)          ;    //PC0=1  

                    printf("#OK\n\r")     ;    //Sent Echo Command 
              break ;


             case 10 :     //--------------- TRIG-CH10(PC1)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                    cbi(PORTC,1)           ;    //PC1=0 : Trig-CH10   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                    sbi(PORTC,1)           ;    //PC1=1  

                    printf("#OK\n\r")      ;    //Sent Echo Command 
              break ;


             case 11 :     //--------------- TRIG-CH11(PC2)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                    cbi(PORTC,2)           ;    //PC2=0 : Trig-CH11   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                    sbi(PORTC,2)           ;    //PC2=1  

                    printf("#OK\n\r")      ;    //Sent Echo Command 
              break ;


            case 12 :     //--------------- TRIG-CH12(PC3)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                    cbi(PORTC,3)           ;    //PC3=0 : Trig-CH12   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                    sbi(PORTC,3)           ;    //PC3=1  

                    printf("#OK\n\r")      ;    //Sent Echo Command 
              break ;


            case 13 :     //--------------- TRIG-CH13(PC4)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                    cbi(PORTC,4)           ;    //PC4=0 : Trig-CH13   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                    sbi(PORTC,4)           ;    //PC4=1  

                    printf("#OK\n\r")      ;    //Sent Echo Command 
              break ;



            case 14 :     //--------------- TRIG-CH14(PC5)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                    cbi(PORTC,5)           ;    //PC5=0 : Trig-CH14   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                    sbi(PORTC,5)           ;    //PC5=1  

                    printf("#OK\n\r")      ;    //Sent Echo Command 
              break ;


             case 15 :     //--------------- TRIG-CH15(PC6)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                    cbi(PORTC,6)           ;    //PC6=0 : Trig-CH15   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                    sbi(PORTC,6)           ;    //PC6=1  

                    printf("#OK\n\r")      ;    //Sent Echo Command 
              break ;


             case 16 :     //--------------- TRIG-CH16(PC7)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                    cbi(PORTC,7)           ;    //PC7=0 : Trig-CH16   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                    sbi(PORTC,7)           ;    //PC7=1  

                    printf("#OK\n\r")      ;    //Sent Echo Command 
              break ;

             
            }   // if switch
          } // if cmm
       }  // if enter


}



/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
 int main(void) 
 {

   Init_Port()       ;

   UART0_Init()      ;
   delay_ms(3000)    ;  //delay for Sync Borad MP3 Ready 

   printf("########### ET-REMOTE MP3 V2. ==> PLAY TRIG MODE #########\n\r") ;

   while(1)
   {
     chk_cmm() ;
   }   
 
}
